<?php

namespace App\Modules\BookingExtraPassenger\Infrastructure;

class BookingExtraPassengerValidators
{

    public const INSERT = [
        'BookingExtraPassenger_Name'         => 'required|string|max:250',
        'BookingExtraPassenger_Abrv'         => 'required|string|max:10',
        'BookingExtraPassenger_Asset'        => 'required|string|max:100',
        'BookingExtraPassenger_Status'       => 'required|int'
    ];

    public const UPDATE = [
        'Id_BookingExtraPassenger'           => 'required|int',
        'BookingExtraPassenger_Name'         => 'required|string|max:250',
        'BookingExtraPassenger_Abrv'         => 'required|string|max:10',
        'BookingExtraPassenger_Asset'        => 'required|string|max:100',
        'BookingExtraPassenger_Status'       => 'required|int'
    ];

    public const MASK = [
        'Id_BookingExtraPassenger'          => 'required|int',
        'BookingExtraPassenger_Mask'        => 'required|int',
    ];

    public const LIST_BY_IDS = [
        'Ids'                               => 'required|array',
        'Ids.*'                             => 'required|int',
    ];

    public const DELETE = [
        'Keep_InvoiceDetail' => 'required|int',
        'Generate_More' => 'required|int',
        'InvoiceDetail_Price' => 'required|numeric',
        'InvoiceDetail_Description' => 'required|string|max:250'
    ];

    public const MASSIVE_UPDATE = [
        'BookingExtraPassenger'                 =>  'required|array',
        'BookingExtraPassenger.*'               =>  'required|int',
        'BookingExtraPassenger_DateEntryStart'  =>  'required|string',
        'BookingExtraPassenger_Code'            =>  'required|string|max:100',
        'BookingExtraPassenger_Amount'          =>  'required|numeric',
        'BookingExtraPassenger_Remark'          =>  'string',
        'BookingExtraPassenger_HourEntryStart'  =>  'required|string',
        'BookingExtraPassenger_HourEntryEnd'    =>  'required|string',
        'BookingExtraPassenger_DatePurchase'    =>  'required|string',
    ];
}
