<?php

namespace App\Modules\BookingCalendar\Application\List;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class ListBookingCalendarQuery implements Query
{
    public function __construct(
        private int $idCategoryTour,
        private int $idTypeTour,
        private int $idTour,
        private int $idPackage,
        private string $dateStart,
        private string $dateEnd,
        private string $token
    ) {
    }

    public function idCategoryTour(): int
    {
        return $this->idCategoryTour;
    }

    public function idTypeTour(): int
    {
        return $this->idTypeTour;
    }
    public function idTour(): int
    {
        return $this->idTour;
    }
    public function idPackage(): int
    {
        return $this->idPackage;
    }
    public function dateStart(): string
    {
        return $this->dateStart;
    }
    public function dateEnd(): string
    {
        return $this->dateEnd;
    }
    public function token(): string
    {
        return $this->token;
    }
}
