<?php

namespace App\Modules\BookingAdditional\Application\List;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\BookingAdditional\Application\BookingAdditionalResponse;
use App\Modules\BookingAdditional\Application\BookingAdditionalResponses;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListBookingAdditionalQueryHandler implements QueryHandler
{
    public function __construct(private BookingAdditionalLister $lister)
    {
    }

    public function __invoke(ListBookingAdditionalQuery $query): BookingAdditionalResponses
    {
        return new BookingAdditionalResponses(...array_map(
            fn ($index) => new BookingAdditionalResponse(
                $index->id()->value(),
                $index->name()->value(),
                $index->abrv()->value(),
                $index->type()->value(),
                $index->status()->value(),
                $index->idBookingTourPassenger()->value(),
                $index->idInternal()->value(),
            ),
            $this->lister->__invoke(new IdBookingTourPassenger($query->getIdBookingTourPassenger()), $query->getAction())
        ));
    }
}
