<?php

namespace App\Modules\BookingAdditional\Application\List;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\BookingAdditional\Domain\BookingAdditionalRepository;
use App\Modules\BookingAdditional\Domain\ListBookingAdditional;

final class BookingAdditionalLister
{
    public function __construct(private BookingAdditionalRepository $repository)
    {
    }

    public function __invoke(IdBookingTourPassenger $idBookingTourPassenger, string $action)
    {
        return $this->repository->search(new ListBookingAdditional($idBookingTourPassenger, $action));
    }
}
