<?php

namespace App\Modules\BookingAdditional\Application\Create;

use App\Modules\BookingAdditional\Domain\BookingAdditional;
use App\Modules\BookingAdditional\Domain\BookingAdditionalRepository;

final class BookingAdditionalCreator
{
    public function __construct(private BookingAdditionalRepository $repository)
    {
    }

    public function __invoke(BookingAdditional $creator): CreateBookingAdditionalResponse
    {
        return new CreateBookingAdditionalResponse($this->repository->insert($creator));
    }
}
