<?php

namespace App\Modules\Booking\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class IndexBooking implements StorageCriteria
{

    public function __construct(
        private IdBooking $id,
        private bool $lockInShare = false
    ) {}

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = Booking::select('`b`');

        return DB::select(
            "SELECT $select
            FROM `t_booking` `b`
            WHERE `b`.`Id_Booking` = ?
            AND `b`.`Booking_Status` <> 0",
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            return null;
        }
        return $data[0];
    }
}
