<?php

namespace App\Modules\Booking\Application\Find;

use App\Modules\Booking\Domain\Booking;
use App\Modules\Booking\Domain\IdBooking;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class FindBookingQueryHandler implements QueryHandler
{

    public function __construct(
        private BookingFinder $bookingFinder
    ) {}

    public function handle(FindBookingQuery $query)
    {
        return $this->bookingFinder->__invoke(new IdBooking($query->id()))
            ->either(
                fn(Booking $booking) => new FindBookingQueryResponse(
                    $booking->id()->value(),
                    $booking->date()->value(),
                    $booking->dateConfirm()->value(),
                    $booking->dateStart()->value(),
                    $booking->dateBriefing()->value(),
                    $booking->placeBriefing()->value(),
                    $booking->code()->value(),
                    $booking->historyChanges()->value(),
                    $booking->hotel()->value(),
                    $booking->observation()->value(),
                    $booking->internalRemark()->value(),
                    $booking->receipt()->value(),
                    $booking->type()->value(),
                    $booking->lastMinute()->value(),
                    $booking->assigned()->value(),
                    $booking->status()->value(),
                    $booking->manuallyConfirmed()->value(),
                    $booking->inPerson()->value(),
                    $booking->passengerAmount()->value(),
                    $booking->checkedInPassengers()->value(),
                    $booking->lastPassenger()->value(),
                    $booking->idBooking_Replace()->value(),
                    $booking->idAdmin()->value(),
                    $booking->idGuideLanguage()->value(),
                    $booking->idLanguage()->value(),
                    $booking->idUser()->value(),
                    $booking->idUser_Additional()->value(),
                    $booking->idBookingRelationship()->value(),
                    $booking->idBookingReferredFrom()->value(),
                ),
                fn(BookingNotFound $ex) => throw new NotFoundHttpException($ex->getMessage(), null, $ex->getCode())
            );
    }
}
