<?php

namespace App\Modules\Batch\Infrastructure;

use App\Modules\Batch\Domain\BatchRequest;
use App\Modules\Batch\Domain\RouteDispatcher;
use App\Modules\Shared\Infraestructure\BasicExceptionHandler;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

class LaravelRouteDispatcher implements RouteDispatcher
{
    public function dispatch(BatchRequest $request)
    {
        $rq = Request::create(
            $request->resource()->value(),
            $request->method()->value(),
            $request->body()->value()
        );
        $rq->headers->set('Token', $request->token()->value());
        $rq->headers->set('Url', $request->url()->value());
        $rq->server->add(['REMOTE_ADDR' => $request->ip()->value()]);
        try {
            return json_decode(app()->handle($rq)->getContent());
        } catch (\Throwable $th) {
            return json_decode(BasicExceptionHandler::handleException($th)->getContent());
        }
    }
}
