<?php

namespace App\Modules\Batch\Application\Run;

use App\Modules\Batch\Domain\Batch;
use App\Modules\Batch\Domain\BatchBody;
use App\Modules\Batch\Domain\BatchIp;
use App\Modules\Batch\Domain\BatchMethod;
use App\Modules\Batch\Domain\BatchRequest;
use App\Modules\Batch\Domain\BatchResource;
use App\Modules\Batch\Domain\BatchToken;
use App\Modules\Batch\Domain\BatchUrl;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class RunBatchQueryHandler implements QueryHandler
{
    public function __construct(private BatchRunner $updater)
    {
    }

    public function __invoke(RunBatchQuery $query): RunBatchQueryResponse
    {
        $requests = array_map(fn($q) => new BatchRequest(
            new BatchMethod($q['Method']),
            new BatchResource($q['Resource']),
            new BatchBody($q['Body']),
            new BatchToken($query->token()),
            new BatchUrl($query->url()),
            new BatchIp($query->ip())
        ), $query->batch());
        $model = new Batch(...$requests);
        return $this->updater->__invoke($model);
    }
}
