<?php

namespace App\Modules\Admin\Application\Index;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class AdminIndexerQueryHandler implements QueryHandler
{
    public function __construct(private AdminIndexer $inserter)
    {
    }

    public function __invoke(AdminIndexerQuery $query): AdminIndexerResponse
    {
        return $this->inserter->__invoke(new IdAdmin($query->getId()));
    }
}
