<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class MailBooking extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        public string $Subject,
        public $Content,
        public $Pdf,
        public $PdfName,
        public array $ReplyToValues
    ) {
    }

    public function build()
    {
        return $this->view('Mail_Body.v_User_Booking')
            ->subject($this->Subject)
            ->with($this->Content)
            ->replyTo($this->ReplyToValues)
            ->attachData($this->Pdf, $this->PdfName, [
                'mime' => 'application/pdf',
            ]);
    }
}
