<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\DB;
use Throwable;

class TransactionMiddleware
{
    public function handle($request, Closure $next)
    {
        DB::beginTransaction();
        try {
            $response = $next($request);
            DB::commit();
        } catch(Throwable $th) {
            DB::rollBack();
            throw $th;
        }
        return $response;
    }
}
