<?php

namespace App\Http\Middleware;

use Closure;
use Symfony\Component\HttpFoundation\BinaryFileResponse;

class CorsMiddleware
{
    public function handle($request, Closure $next)
    {
        $headers = [];
        if (config('var.SEND_ACCESS_CONTROL_ALLOW_ORIGIN', false) == '1') {
            $headers['Access-Control-Allow-Origin']  = '*';
        }
        $headers['Access-Control-Allow-Methods']     = 'POST, GET, OPTIONS, PUT, DELETE';
        $headers['Access-Control-Allow-Credentials'] = 'true';
        $headers['Access-Control-Max-Age']           = '86400';
        $headers['Access-Control-Allow-Headers']     = 'Content-Type, Token, Url,Id, X-Requested-With,Booking_Token';

        if ($request->isMethod('OPTIONS')) {
            return response('', 200, $headers);
        }
        $response = $next($request);
        if ($response instanceof BinaryFileResponse) {
            return $response;
        }

        foreach ($headers as $key => $value) {
            $response->header($key, $value);
        }
        return $response;
    }
}
