<?php

namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use Illuminate\Support\Facades\DB;

class c_Type_Payment extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->oDomain = "Type Payment";
        $this->history = new HistoryData(HistoryTables::type_payment);
    }

    public function insert(Request $Request)
    {
        $oResponse  = array();
        $oValParams = [
            'TypePayment_Name'     => 'required|string|max:250',
            'TypePayment_Abrv'     => 'required|string|max:4',
            'TypePayment_Asset'    => 'string|max:100',
            'TypePayment_RequireGateway' => 'required|int',
            'TypePayment_Status'   => 'required|int'
        ];


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = [
                Str::title($Request->input("TypePayment_Name")),
                Str::title($Request->input("TypePayment_Name")),
                Str::upper($Request->input("TypePayment_Abrv")),
                $Request->input("TypePayment_Asset"),
                $Request->input("TypePayment_RequireGateway"),
                $Request->input("TypePayment_Status")
            ];
            $oData = DB::select('call sp_type_payment_insert(?,?,?,?,?,?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                //region HISTORY EXEC
                $this->history->insertBasic($Request);
                //endregion
            } else {
            }

            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Update(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(
            'Id_TypePayment'       => 'required|int',
            'TypePayment_Name'     => 'required|string|max:250',
            'TypePayment_Abrv'     => 'required|string|max:4',
            'TypePayment_Asset'    => 'string|max:100',
            'TypePayment_Order'    => 'required|int',
            'TypePayment_RequireGateway' => 'required|int',
            'TypePayment_Status'   => 'required|int'
        );
        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            //region HISTORY VARIABLES
            $this->history->obtainOld($Request->input('Id_TypePayment'));
            //endregion
            $oParam = array(
                $Request->input("Id_TypePayment"),
                Str::title($Request->input("TypePayment_Name")),
                Str::upper($Request->input("TypePayment_Abrv")),
                $Request->input("TypePayment_Asset"),
                $Request->input("TypePayment_Order"),
                $Request->input("TypePayment_RequireGateway"),
                $Request->input("TypePayment_Status")
            );
            $oData = DB::select('call sp_type_payment_update(?,?,?,?,?,?,?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                //region HISTORY EXEC
                $this->history->updateBasic($Request->input("Id_TypePayment"), $Request);
                //endregion
            } else {
            }

            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Delete(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {

            //region HISTORY
            $this->history->obtainOld($Id);
            //endregion

            $oParam = array($Id);
            $oData  = DB::select('call sp_type_payment_delete(?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                //region HISTORY EXEC
                $this->history->deleteBasic($Id, $Request);
                //endregion
            } else {
            }

            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Index(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array($Id);
            $oData  = DB::select('call sp_type_payment_index(?)', $oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain . " Index";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function List(Request $Request, $Id)
    {
        $oResponse  = array();

        $oResponse = ParamsValidator::Validate_Action($Id, $this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            $oParam = [
                $Id,
                config('var.PATH_PUBLIC')
            ];
            $oData  = DB::select('call sp_type_payment_list(?,?)', $oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain . " list " . $Id;
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Selector(Request $Request, $Id)
    {
        if (is_numeric($Id)) {
            return SELF::Index($Request, $Id);
        } else {
            return SELF::List($Request, $Id);
        }
    }
}
