<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;

class c_Package_Tour_Upgrade extends Controller
{
	private $oDomain;
	/** @var HistoryData */
	private $history;

	public function __construct()
	{
		$this->oDomain = "Package Tour Upgrade";
		$this->history = new HistoryData (HistoryTables::package_tour_upgrade);
	}

	public function Insert (Request $Request) {
		$oValParams = [
            'Id_PackageTour'		            => 'required|int',
			'Id_Upgrade'			            => 'required|int',
			'PackageTourUpgrade_Passenger'		=> 'required|int',
        ];


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {			
			$oParam = [
				$Request->input("PackageTourUpgrade_Passenger"),
                $Request->input("Id_PackageTour"),
				$Request->input("Id_Upgrade"),
            ];

			$oData = DB::select('call sp_package_tour_upgrade_insert(?,?,?)', $oParam);
			
			if ($oData[0]->Response_Success == 1) {
				//region HISTORY EXEC
				$this->history->insertBasic ($Request);
				//endregion
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
    }
    
	public function Update(Request $Request) {
		$oValParams = [
            'Id_PackageTourUpgrade'   		=> 'required|int',
            'Id_PackageTour'		            => 'required|int',
            'Id_Upgrade'			            => 'required|int',
        ];


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request ($Request, $oValParams, $this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			
			//region HISTORY VARIABLES
			$this->history->obtainOld($Request->input('Id_PackageTourUpgrade'));
			//endregion

			$oParam = [
                $Request->input("Id_PackageTourUpgrade"),
				$Request->input("PackageTourUpgrade_Passenger"),
                $Request->input("Id_PackageTour"),
                $Request->input("Id_Upgrade"),
            ];
			$oData = DB::select('call sp_package_tour_upgrade_update(?,?,?,?)', $oParam);

			if ($oData[0]->Response_Success == 1) {
				//region HISTORY EXEC
				$this->history->updateBasic ( $Request->input("Id_PackageTourUpgrade"), $Request );
				//endregion
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);

	}
	public function Delete (Request $Request, $Id) {

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id ($Id, $this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			
			//region HISTORY
			$this->history->obtainOld($Id);
			//endregion

			$oParam = array( $Id );
			$oData 	= DB::select('call sp_package_tour_upgrade_delete(?)',$oParam);
			
			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				//region HISTORY EXEC
				$this->history->deleteBasic ($Id, $Request);
				//endregion
			} else { }
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
    }
    
	public function Index(Request $Request, $Id) {

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id ($Id, $this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {		
			$oParam = array( $Id );
			$oData 	= DB::select('call sp_package_tour_upgrade_index(?)',$oParam);
			
			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." Index";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function List(Request $Request, $Id_PackageTour){
		$oResponse  = array();
		
		$oResponse = ParamsValidator::Validate_Id ($Id_PackageTour, $this->oDomain);
		
		if ($oResponse["Response_Code"] == 200) {
            $oParam = [ $Id_PackageTour ];
            $oData  = DB::select('call sp_package_tour_upgrade_list(?)',$oParam);

            $oResponse["Response_Status"]			= 200;
            $oResponse["Response_Code"]				= 200;
            $oResponse["Response_Domain"]			= $this->oDomain;
            $oResponse["Response_Message"]			= $this->oDomain . " list ";
            $oResponse["Response_Data"]				= $oData;
            $oResponse["Response_Error_Message"]	= "";
            $oResponse["Response_Error_Reason"]		= "";
        
		}
		return ResponseBuilder::Response($oResponse);
	}

	
}