<?php

namespace App\Http\Controllers\Owner\WebContactMessageDetail;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\WebContactMessageDetail\Application\Create\CreateWebContactMessageDetailQuery;
use App\Modules\WebContactMessageDetail\Application\Create\CreateWebContactMessageDetailResponse;
use App\Modules\WebContactMessageDetail\Infraestructure\WebContactMessageDetailValidators;

class WebContactMessageDetailInsertController extends Controller
{
    private $domain;
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "WebContactMessageDetail";
        $this->history = new HistoryData(HistoryTables::WEB_CONTACT);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, WebContactMessageDetailValidators::INSERT);

        /** @var CreateWebContactMessageDetailResponse $response */
        $response = $this->queryBus->ask(new CreateWebContactMessageDetailQuery(
            $request->input('WebContactMessageDetail_DateStart'),
            $request->input('WebContactMessageDetail_Package'),
            $request->input('WebContactMessageDetail_Status'),
            $request->input('Id_WebContactMessage'),
            $request->input('Id_Package', 0),
        ));
        $this->history->insertBasic($request, $response->response()['Response_Data']['Id']);

        return ResponseBuilder::Response($response->response());
    }
}
