<?php

namespace App\Http\Controllers\Owner\WebContactMessage;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\WebContactMessage\Application\Update\UpdateWebContactMessageQuery;
use App\Modules\WebContactMessage\Application\Update\UpdateWebContactMessageQueryResponse;
use App\Modules\WebContactMessage\Infraestructure\WebContactMessageValidators;

class WebContactMessageUpdateController extends Controller
{
    private $domain;
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "WebContactMessage";
        $this->history = new HistoryData(HistoryTables::WEB_CONTACT);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, WebContactMessageValidators::UPDATE);

        /** @var UpdateWebContactMessageQueryResponse $response */
        $response = $this->queryBus->ask(new UpdateWebContactMessageQuery(
            $request->input('Id_WebContactMessage'),
            $request->input('WebContactMessage_Message'),
            $request->input('WebContactMessage_Adults'),
            $request->input('WebContactMessage_Children'),
            $request->input('WebContactMessage_Subscription'),
            $request->input('WebContactMessage_Status'),
            $request->input('Id_WebContact'),
        ));

        $this->history->updateBasic($request->input("Id_WebContactMessage"), $request);

        return ResponseBuilder::Response($response->response());
    }
}
