<?php

namespace App\Http\Controllers\Owner\TypeBookingAssign;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\TypeBookingAssign\Application\List\ListTypeBookingAssignQuery;
use App\Modules\TypeBookingAssign\Application\List\ListTypeBookingAssignQueryResponse;

class TypeBookingAssignListController extends Controller
{
    private $domain = 'TypeBookingAssign';
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Action, Request $Request)
    {
        /** @var ListTypeBookingAssignQueryResponse $response */
        $response = $this->queryBus->ask(new ListTypeBookingAssignQuery($Action));
        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->response(), '', $this->domain));
    }
}
