<?php

namespace App\Http\Controllers\Owner\TourHtlCamp;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\TourHtlCamp\Application\TourHtlCampFinder;
use App\Modules\TourHtlCamp\Infraestructure\MysqlTourHtlCampRepository;
use App\Modules\TourHtlCamp\Domain\THCIdTour;
use Throwable;

class TourHtlCampListController extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->oDomain = "TourHtlCamp";
        $this->history = new HistoryData(HistoryTables::TOUR_HTL_CAMP);
    }

    public function __invoke($Id_Tour, $Action)
    {
        $oResponse = (new TourHtlCampFinder(new MysqlTourHtlCampRepository))->__invoke(new THCIdTour($Id_Tour), $Action);
        return ResponseBuilder::Response($oResponse);
    }
}
