<?php

namespace App\Http\Controllers\Owner\TourHtlCamp;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\TourHtlCamp\Application\TourHtlCampIndexer;
use App\Modules\TourHtlCamp\Application\TourHtlCampInserter;
use App\Modules\TourHtlCamp\Domain\THCIdHtlCamp;
use App\Modules\TourHtlCamp\Domain\TourHtlCamp;
use App\Modules\TourHtlCamp\Domain\TourHtlCampDay;
use App\Modules\TourHtlCamp\Domain\TourHtlCampStatus;
use App\Modules\TourHtlCamp\Domain\IdTourHtlCamp;
use App\Modules\TourHtlCamp\Infraestructure\TourHtlCampValidators;
use App\Modules\TourHtlCamp\Infraestructure\MysqlTourHtlCampRepository;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\TourHtlCamp\Domain\THCIdTour;

class TourHtlCampInsertController extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->oDomain = "TourHtlCamp";
        $this->history = new HistoryData(HistoryTables::TOUR_HTL_CAMP);
    }

    public function __invoke(Request $Request)
    {
        (new LaravelValidator)->validate($Request->all(), $this->oDomain, TourHtlCampValidators::insert);

        $oResponse = (new TourHtlCampInserter(new MysqlTourHtlCampRepository))->__invoke(
            new TourHtlCamp(
                new TourHtlCampDay($Request->input('TourHtlCamp_Day')),
                new TourHtlCampStatus($Request->input('TourHtlCamp_Status')),
                new THCIdTour($Request->input('Id_Tour')),
                new THCIdHtlCamp($Request->input('Id_HtlCamp'))
            )
        );
        $this->history->insert(
            (new TourHtlCampIndexer(new MysqlTourHtlCampRepository))->__invoke(new IdTourHtlCamp($oResponse['Response_Data']['Id'])),
            $Request,
            $oResponse['Response_Data']['Id']
        );

        return ResponseBuilder::Response($oResponse);
    }
}
