<?php

namespace App\Http\Controllers\Owner\StatusGroup;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\StatusGroup\Application\List\ListStatusGroupQuery;
use App\Modules\StatusGroup\Application\List\ListStatusGroupQueryResponse;

class StatusGroupListController extends Controller
{
    private $domain = 'StatusGroup';
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Action, Request $Request)
    {
        /** @var ListStatusGroupQueryResponse $response */
        $response = $this->queryBus->ask(new ListStatusGroupQuery($Action));
        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->response(), '', $this->domain));
    }
}
