<?php

namespace App\Http\Controllers\Owner\QuestionTypeProvider;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\QuestionTypeProvider\Application\Create\QuestionTypeProviderInserterQuery;
use App\Modules\QuestionTypeProvider\Application\Create\QuestionTypeProviderInserterResponse;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\QuestionTypeProvider\Infraestructure\QuestionTypeProviderValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class QuestionTypeProviderInsertController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "QuestionTypeProvider";
        $this->history = new HistoryData(HistoryTables::QUESTION_TYPE_PROVIDER);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, QuestionTypeProviderValidators::INSERT);

        /** @var QuestionTypeProviderInserterResponse $response */
        $response = $this->queryBus->ask(
            new QuestionTypeProviderInserterQuery(
                $request->input('QuestionTypeProvider_Show'),
                $request->input('QuestionTypeProvider_ForPassenger'),
                $request->input('QuestionTypeProvider_Status'),
                $request->input('Id_Question'),
                $request->input('Id_TypeProvider')
            )
        );
        $this->history->insertBasic($request, $response->response()['Response_Data']['Id']);

        return ResponseBuilder::Response($response->response());
    }
}
