<?php

namespace App\Http\Controllers\Owner\ProviderTypeProvider;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\ProviderTypeProvider\Application\Update\ProviderTypeProviderUpdaterQuery;
use App\Modules\ProviderTypeProvider\Application\Update\ProviderTypeProviderUpdaterResponse;
use App\Modules\ProviderTypeProvider\Infraestructure\ProviderTypeProviderValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class ProviderTypeProviderUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "ProviderTypeProvider";
        $this->history = new HistoryData(HistoryTables::PROVIDER_TYPE_PROVIDER);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, ProviderTypeProviderValidators::UPDATE);

        $this->history->obtainOld($request->input("Id_ProviderTypeProvider"));

        /** @var ProviderTypeProviderUpdaterResponse $response */
        $response = $this->queryBus->ask(
            new ProviderTypeProviderUpdaterQuery(
                $request->input('Id_ProviderTypeProvider'),
                $request->input('ProviderTypeProvider_Status'),
                $request->input('Id_Provider'),
                $request->input('Id_TypeProvider')
            )
        );

        $this->history->updateBasic($request->input("Id_ProviderTypeProvider"), $request);
        return ResponseBuilder::Response($response->response());
    }
}
