<?php
namespace App\Http\Controllers\Owner\PassengerReview;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\PassengerReview\Application\PassengerReviewRemove;
use App\Modules\PassengerReview\Infraestructure\MysqlPassengerReviewRemoveRepository;

final class Remove extends Controller
{
    private $oDomain;

    public function __construct()
    {
        $this->oDomain = 'PassengerReview';
    }

    public function __invoke(int $Id_PassengerReview)
    {
        $response = (new PassengerReviewRemove(new MysqlPassengerReviewRemoveRepository))($Id_PassengerReview);
        return ResponseBuilder::Response($response);
    }
}
