<?php
namespace App\Http\Controllers\Owner\LeadBookingTourPassenger;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\LeadBookingTourPassenger\Application\Delete\LeadBookingTourPassengerDeleterQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingTourPassengerDeleteController extends Controller
{
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "LeadBookingTourPassenger";
        $this->history = new HistoryData(HistoryTables::LEAD_BOOKING_TOUR_PASSENGER);
    }

    public function __invoke(Request $request, $Id)
    {
        $this->history->obtainOld($Id);
        /** @var LeadBookingTourPassengerDeleterResponse $response */
        $response = $this->queryBus->ask(new LeadBookingTourPassengerDeleterQuery($Id));

        $this->history->deleteBasic($Id, $request);

        return ResponseBuilder::Response($response->response());
    }
}
