<?php

namespace App\Http\Controllers\Owner\LeadBookingServicePassenger;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\LeadBookingServicePassenger\Application\Create\LeadBookingServicePassengerInserterQuery;
use App\Modules\LeadBookingServicePassenger\Application\Create\LeadBookingServicePassengerInserterResponse;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\LeadBookingServicePassenger\Infraestructure\LeadBookingServicePassengerValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingServicePassengerInsertController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "LeadBookingServicePassenger";
        $this->history = new HistoryData(HistoryTables::LEAD_BOOKING_SERVICE_PASSENGER);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate(
            $request->all(),
            $this->domain,
            LeadBookingServicePassengerValidators::INSERT
        );
        /** @var LeadBookingServicePassengerInserterResponse $response */
        $response = $this->queryBus->ask(new LeadBookingServicePassengerInserterQuery(
            $request->input('LeadBookingServicePassenger_Status'),
            $request->input('Id_LeadBookingService'),
            $request->input('Id_LeadBookingTourPassenger')
        ));
        $this->history->insertBasic($request, $response->response()['Response_Data']['Id']);

        return ResponseBuilder::Response($response->response());
    }
}
