<?php

namespace App\Http\Controllers\Owner\LeadBookingPackage;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\LeadBookingPackage\Application\Create\InsertLeadBookingPackageQuery;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\LeadBookingPackage\Infrastructure\LeadBookingPackageValidators;
use App\Modules\LeadBookingTour\Application\UpdateDate\UpdateDateLeadBookingTourQuery;
use App\Modules\LeadBookingTour\Application\UpdateDate\UpdateDateLeadBookingTourResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingPackageInsertController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "LeadBookingPackage";
        $this->history = new HistoryData(HistoryTables::LEAD_BOOKING_TOUR);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, LeadBookingPackageValidators::INSERT);
        /** @var InsertLeadBookingPackageResponse $response */
        $response = $this->queryBus->ask(new InsertLeadBookingPackageQuery(
            $request->input('LeadBookingTourDateStart'),
            $request->input('LeadBookingTourType'),
            $request->input('IdLeadBooking'),
            $request->input('IdPackage'),
            $request->input('Passengers')
        ));
        return ResponseBuilder::Response($response->response());
    }
}
