<?php

namespace App\Http\Controllers\Owner\Info;

use Illuminate\Support\Facades\DB;

class TourFinder
{

    public function getPackageTours($tour)
    {
        return $this->getTourItems($tour);
    }

    public function getTourItems($tour)
    {
        return (object)[
            'Tour' => $tour,
            'Upgrades' => $this->getUpgrades($tour->Id_Tour),
            'Extras' => $this->getExtras($tour->Id_Tour),
            'Equipment' => $this->getEquipment($tour->Id_Tour)
        ];
    }

    public function getUpgrades($idTour)
    {
        return DB::select('SELECT `u`.`Id_Upgrade`, `u`.`Upgrade_Name`, 1 as `TourUpgrade_RequireDay`, 1 as `TourUpgrade_Day`
            FROM `t_package_tour_upgrade` `ptu`
            INNER JOIN `t_package_tour` `pt` ON `pt`.`Id_PackageTour` = `ptu`.`Id_PackageTour`
            INNER JOIN `t_upgrade` `u` ON `u`.`Id_Upgrade` = `ptu`.`Id_Upgrade`
            WHERE `pt`.`Id_Tour` = ?', [$idTour]);
    }

    public function getExtras($idTour)
    {
        return DB::select('SELECT `e`.`Id_Extra`, `e`.`Extra_Name`, 1 as `TourExtra_RequireDay`, 1 as `TourExtra_Day`
            FROM `t_package_tour_extra` `pte`
            INNER JOIN `t_package_tour` `pt` ON `pt`.`Id_PackageTour` = `pte`.`Id_PackageTour`
            INNER JOIN `t_extra` `e` ON `e`.`Id_Extra` = `pte`.`Id_Extra`
            WHERE `pt`.`Id_Tour` = ?', [$idTour]);
    }

    public function getEquipment(int $idTour)
    {
        return DB::select('SELECT `e`.`Id_Equipment`, `i`.`Item_Name`
            FROM `t_package_tour_equipment` `te`
            INNER JOIN `t_equipment` `e` ON `e`.`Id_Equipment` = `te`.`Id_Equipment`
            INNER JOIN `t_package_tour` `pt` ON `pt`.`Id_PackageTour` = `te`.`Id_PackageTour`
            INNER JOIN `t_item` `i` ON `i`.`Id_Item` = `e`.`Id_Item`
            WHERE `pt`.`Id_Tour` = ?', [$idTour]);
    }
}