<?php

namespace App\Http\Controllers\Owner\Info;

use Illuminate\Support\Facades\DB;

class TourController
{
    public function __invoke()
    {
        $tours = $this->getTours();
        $tours = array_map([$this, 'getTourItems'], $tours);
        echo "<style> table, th, td {
            border: 1px solid black;
            border-collapse: collapse;
          } </style>";
        echo implode("\n<br /><br />", array_map([$this, 'generateTable'], $tours));
    }

    public function generateTable($tour)
    {
        $table = "<tr><td colspan=\"10\" style=\"text-align:center\"><b>{$tour->Tour->Tour_Code}</b></td></tr>";
        $table .= "<tr><td colspan=\"10\" style=\"text-align:center\"><b>{$tour->Tour->Tour_Name}</b></td></tr>";
        $table .= "<tr>
                <td><b>Servicios</b></td>
                <td><b>Día en el tour</b></td>
                <td><b>Hora</b></td>
                <td><b>Default</b></td>
                <td><b>Extras</b></td>
                <td><b>Día en el tour</b></td>
                <td><b>Hora</b></td>
                <td><b>Default</b></td>
                <td><b>Equipamientos</b></td>
                <td><b>Default</b></td>
            </tr>";
        $max = max(count($tour->Upgrades), count($tour->Extras), count($tour->Equipment));
        for ($i = 0; $i < $max; $i++) {
            $table .= "<tr>";
            if (isset($tour->Upgrades[$i])) {
                $table .= "<td>{$tour->Upgrades[$i]->Upgrade_Name}</td>";
                $table .= "<td>" . ($tour->Upgrades[$i]->TourUpgrade_RequireDay == 2 ? $tour->Upgrades[$i]->TourUpgrade_Day : '') . "</td>";
                $table .= "<td></td><td></td>";
            } else {
                $table .= "<td></td><td></td><td></td><td></td>";
            }
            if (isset($tour->Extras[$i])) {
                $table .= "<td>{$tour->Extras[$i]->Extra_Name}</td>";
                $table .= "<td>" . ($tour->Extras[$i]->TourExtra_RequireDay == 2 ? $tour->Extras[$i]->TourExtra_Day : '') . "</td>";
                $table .= "<td></td><td></td>";
            } else {
                $table .= "<td></td><td></td><td></td><td></td>";
            }
            if (isset($tour->Equipment[$i])) {
                $table .= "<td>{$tour->Equipment[$i]->Item_Name}</td><td></td>";
            } else {
                $table .= "<td></td><td></td>";
            }
            $table .= "</tr>";
        }
        return "<table>{$table}</table>";
    }

    public function getTourItems($tour)
    {
        $PackageTours = $this->getPackageTours($tour);
        $upgrades = $this->appendElementsBy($this->getUpgrades($tour->Id_Tour), $PackageTours->Upgrades, 'Id_Upgrade');
        $extras = $this->appendElementsBy($this->getExtras($tour->Id_Tour), $PackageTours->Extras, 'Id_Extra');
        $equipment = $this->appendElementsBy($this->getEquipment($tour->Id_Tour), $PackageTours->Equipment, 'Id_Equipment');
        return (object)[
            'Tour' => $tour,
            'Upgrades' => $upgrades,
            'Extras' => $extras,
            'Equipment' => $equipment
        ];
    }

    public function appendElementsBy($target, $elements, $key)
    {
        foreach ($elements as $element) {
            $found = false;
            foreach ($target as $value) {
                if ($value->$key == $element->$key) {
                    $found = true;
                }
            }
            if (!$found) {
                $target[] = $element;
            }
        }
        return $target;
    }

    public function getPackageTours($tour)
    {
        return (new TourFinder())->getPackageTours($tour);
    }

    public function getTours()
    {
        return DB::select('SELECT * FROM t_tour WHERE Tour_Status = 2');
    }

    public function getUpgrades(int $idTour)
    {
        return DB::select('SELECT `u`.`Id_Upgrade`, `u`.`Upgrade_Name`, `tu`.`TourUpgrade_RequireDay`, `tu`.`TourUpgrade_Day`
            FROM `t_tour_upgrade` `tu`
            INNER JOIN `t_tour_upgrade_type` `tut` ON `tut`.`Id_TourUpgradeType` = `tu`.`Id_TourUpgradeType`
            INNER JOIN `t_upgrade` `u` ON `u`.`Id_Upgrade` = `tu`.`Id_Upgrade`
            WHERE `tut`.`Id_Tour` = ?
            AND `tu`.`TourUpgrade_Status` = 2', [$idTour]);
    }

    public function getExtras(int $idTour)
    {
        return DB::select('SELECT `e`.`Id_Extra`, `e`.`Extra_Name`, `te`.`TourExtra_RequireDay`, `te`.`TourExtra_Day`
            FROM `t_tour_extra` `te`
            INNER JOIN `t_tour_extra_type` `tet` ON `tet`.`Id_TourExtraType` = `te`.`Id_TourExtraType`
            INNER JOIN `t_extra` `e` ON `e`.`Id_Extra` = `te`.`Id_Extra`
            WHERE `tet`.`Id_Tour` = ?
            AND `te`.`TourExtra_Status` = 2', [$idTour]);
    }

    public function getEquipment(int $idTour)
    {
        return DB::select('SELECT `e`.`Id_Equipment`, `i`.`Item_Name`
            FROM `t_tour_equipment` `te`
            INNER JOIN `t_equipment` `e` ON `e`.`Id_Equipment` = `te`.`Id_Equipment`
            INNER JOIN `t_tour_equipment_type` `tet` ON `tet`.`Id_TourEquipmentType` = `te`.`Id_TourEquipmentType`
            INNER JOIN `t_item` `i` ON `i`.`Id_Item` = `e`.`Id_Item`
            WHERE `tet`.`Id_Tour` = ?
            AND `te`.`TourEquipment_Status` = 2', [$idTour]);
    }
}
