<?php

namespace App\Http\Controllers\Owner\Info;

use App\Http\Controllers\Owner\BookingCreator;
use App\Http\Controllers\Owner\Passenger\PassengerUpdater;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class NiubizPurchaseGenerateController
{
    public function __construct(
        private QueryBus $queryBus,
        private BookingCreator $bookingCreator,
        private PassengerUpdater $passengerUpdater
    ) {
    }
    public function __invoke(Request $request, $IdNiubizPurchase)
    {
        $niubizPurchase = self::getNiubizPurchase($IdNiubizPurchase);

        $data = self::data($niubizPurchase);
        $userId = self::userIdFromPurchase($niubizPurchase);
        $user = self::searchUser(self::userEmail($niubizPurchase));

        if ($userId !== 0) {
            dd(self::card($data), self::amount($niubizPurchase), self::searchBooking($userId));
            return;
        }
        $request = BookingGenerator::from($user, $niubizPurchase, $data);
        $result = BookingGenerator::generate($request, $this->queryBus, $this->bookingCreator, $this->passengerUpdater);
        dd(self::card($data), self::amount($niubizPurchase), $result, self::indexBooking($result['Response_Data']['Id_Booking']));

        // try {
        //     dd(self::card($data), self::amount($niubizPurchase), self::searchBooking(self::userId($user)));
        // } catch (Exception $e) {
        //     $request = BookingGenerator::from($user, $niubizPurchase, $data);
        //     dd(self::card($data), self::amount($niubizPurchase), BookingGenerator::generate($request, $this->queryBus));
        // }
    }

    private static function amount($niubizPurchase)
    {
        return $niubizPurchase->BookingTemp_Amount;
    }

    private static function userEmail($niubizPurchase)
    {
        return $niubizPurchase->BookingTemp_User_Email;
    }

    private static function userIdFromPurchase($niubizPurchase)
    {
        return $niubizPurchase->BookingTemp_Id_User;
    }

    private static function userId($user)
    {
        return $user->Id_User;
    }

    private static function card($data)
    {
        return $data->dataMap->CARD;
    }

    private static function data($niubizPurchase)
    {
        return json_decode($niubizPurchase->BookingTemp_ResponseData);
    }

    private static function searchUser($userEmail)
    {
        return self::index(DB::select('SELECT * FROM t_user WHERE User_Email = ?', [$userEmail]), 'No user found');
    }

    private static function searchBooking($idUser)
    {
        return self::index(DB::select('SELECT * FROM t_booking WHERE Id_User = ?', [$idUser]), 'No booking found');
    }

    private static function indexBooking($idBooking)
    {
        return self::index(DB::select('SELECT * FROM t_booking WHERE Id_Booking = ?', [$idBooking]), 'No booking found');
    }

    private static function getNiubizPurchase($IdNiubizPurchase)
    {
        $np = self::index(DB::select('SELECT * FROM `t_niubiz_purchase` WHERE NiubizPurchase_type = \'BOOKING_TEMP\' AND Id=?;', [$IdNiubizPurchase]), 'No niubiz purchase found');
        return self::index(DB::select('call sp_niubiz_purchase_index(?)', [$np->Id_NiubizPurchase]), 'No niubiz purchase index found');
    }

    private static function index($data, $message)
    {
        if (!count($data)) {
            throw new Exception($message);
        }
        return $data[0];
    }
}
