<?php

namespace App\Http\Controllers\Owner\Info;

use App\Http\Helpers\ParamsValidator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CashMovementGenerator
{

    public static function from($niubizPurchase, $data)
    {
        $invoices = $niubizPurchase->CashMovementTemp_Invoices;
        $request = new Request([
            'CashMovement' => json_encode([
                'CashMovement_Amount' => $niubizPurchase->CashMovementTemp_Amount,
                'CashMovement_Currency' => $data->order->currency,
                'CashMovement_Name' => '-',
                'CashMovement_LastName' => '-',
                'CashMovement_Email' => '-',
                'CashMovement_Country' => '-',
                'CashMovement_City' => '-',
                'CashMovement_Address' => '-',
                'CashMovement_Phone' => '-',
                'CashMovement_DatePayment' => date('Y-m-d H:i:s', strtotime($niubizPurchase->CashMovementTemp_Date) - 5 * 60 * 60),
                'CashMovement_ReceiptNumber' => $data->order->purchaseNumber,
                'CashMovement_CardLast' => '-',
                'CashMovement_CardNumber' => $data->dataMap->CARD,
                'CashMovement_CardBrand' => $data->dataMap->BRAND,
                'CashMovement_CardType' => '-',
                'CashMovement_CardIssuer' => '-',
                'Invoices' => $niubizPurchase->CashMovementTemp_Invoices,
            ]),
            'Id_Schedule' => $niubizPurchase->Id_Schedule
        ]);
        $request->headers->set('Token', $niubizPurchase->BookingTemp_Token);
        return $request;
    }

    public static function generate(Request $Request)
    {

        $oResponse = ParamsValidator::Validate_Request($Request, [
            'Id_Schedule'           => 'required|int',
            'CashMovement'          => 'required|string'
        ], 'CashMovement');

        if ($oResponse["Response_Code"] == 200) {
            $oCashMovement  = json_decode($Request->input('CashMovement'));

            $oParam = [
                $oCashMovement->CashMovement_DatePayment,
                $oCashMovement->CashMovement_Amount,
                $oCashMovement->CashMovement_Currency,
                $oCashMovement->CashMovement_Name,
                $oCashMovement->CashMovement_LastName,
                $oCashMovement->CashMovement_Email,
                $oCashMovement->CashMovement_Country,
                $oCashMovement->CashMovement_City,
                $oCashMovement->CashMovement_Address,
                $oCashMovement->CashMovement_Phone,
                $oCashMovement->CashMovement_ReceiptNumber,
                $oCashMovement->CashMovement_CardLast,
                $oCashMovement->CashMovement_CardNumber,
                $oCashMovement->CashMovement_CardBrand,
                $oCashMovement->CashMovement_CardType,
                $oCashMovement->CashMovement_CardIssuer,
                '',
                2
            ];

            $oDataCashMovement = DB::select('call sp_cash_movement_insert(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,0)', $oParam);
            $oData = $oDataCashMovement;



            if ($oData[0]->Response_Success == 1) {
                $Id_CashMovement = $oData[0]->Id_CashMovement;
                if ($Request->input('Id_Schedule') != 0) {
                    #region Schedule Detail
                    $oInvoice = json_decode($oCashMovement->Invoices);

                    foreach ($oInvoice as $detail) {
                        $oData = DB::select('call sp_cash_movement_detail_insert(?,?,?,?,?)', [
                            $detail->Amount,
                            $oDataCashMovement[0]->Id_CashMovement,
                            $detail->Id_Invoice,
                            1,
                            1
                        ]);
                        if ($oData[0]->Response_Success != 1) {
                            break;
                        }
                    }
                    #endregion

                    #region Schedule
                    if ($oData[0]->Response_Success == 1) {
                        $scheduleData = DB::select('call sp_schedule_pay(?)', [$Request->input("Id_Schedule")]);
                    }

                    #endregion
                } else {
                    $oSuccess = true;
                    $oInvoice = json_decode($oCashMovement->Invoices);

                    foreach ($oInvoice as $detail) {

                        $oData = DB::select('call sp_cash_movement_detail_insert(?,?,?,?,?)', [
                            $detail->Amount,
                            $oData[0]->Id_CashMovement,
                            $detail->Id_Invoice,
                            1,
                            1
                        ]);
                        if ($oData[0]->Response_Success == 0) {
                            $oSuccess = false;
                            break;
                        }
                    }

                    if ($oSuccess == true) {
                        $oData = [[
                            "Response_Status"   => 200,
                            "Response_Code"     => 200,
                            "Response_Message"  => "Pasajeros guardados con éxito",
                            "Response_Reason"   => null
                        ]];

                        $oData = json_decode(json_encode($oData));
                    }
                }
            }

            #region Get data

            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = 'CashMovement';
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;

            #endregion
        }

        return $oResponse;
    }
}
