<?php
namespace App\Http\Controllers\Owner\HtlTypeRoomBed;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\HtlTypeRoomBed\Application\HtlTypeRoomBedResponses;
use App\Modules\HtlTypeRoomBed\Application\List\HtlTypeRoomBedListerQuery;
use App\Modules\HtlTypeRoomBed\Application\List\ListHtlTypeRoomBedQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class HtlTypeRoomBedListController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "HtlTypeRoomBed";
    }

    public function __invoke($IdHtlTypeRoom, $Action)
    {
        $this->transaction->begin();
        /** @var HtlTypeRoomBedResponses $response */
        $response = $this->queryBus->ask(new ListHtlTypeRoomBedQuery($IdHtlTypeRoom, $Action));
        $this->transaction->commit();

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => $response->data(),
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Tipo de Habitación Cama agregado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
