<?php

namespace App\Http\Controllers\Owner\HtlCampBooking;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\HtlCampBooking\Application\Create\CreateHtlCampBookingQuery;
use App\Modules\HtlCampBooking\Application\Create\CreateHtlCampBookingResponse;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingLock;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\HtlCampBooking\Infrastructure\HtlCampBookingValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class HtlCampBookingInsertController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "HtlCampBooking";
        $this->history = new HistoryData(HistoryTables::HTL_CAMP_BOOKING);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, HtlCampBookingValidators::INSERT);
        $this->transaction->begin();
        /** @var CreateHtlCampBookingResponse $response */
        $response = $this->queryBus->ask(new CreateHtlCampBookingQuery(
            date('Y-m-d H:i:s'),
            $request->input('HtlCampBooking_DateStart'),
            0,
            0,
            $request->input('HtlCampBooking_Status'),
            HtlCampBookingLock::VALUE_FALSE,
            $request->input('HtlCampBooking_Remark'),
            $request->input('Id_HtlCamp'),
            $request->input('Id_BookingTour'),
        ));
        $this->transaction->commit();
        $this->history->insertBasic($request, $response->id());
        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => ['id' => $response->id()],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Reserva de campamento agregada con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
