<?php

namespace App\Http\Controllers\Owner\GroupProviderReview;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\GroupProviderReview\Application\List\GroupProviderReviewListerQuery;
use App\Modules\GroupProviderReview\Application\List\GroupProviderReviewListerResponse;
use App\Modules\GroupProviderReview\Application\ListFromGroup\GroupProviderReviewListFromGroupQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class GroupProviderReviewListFromGroupController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "GroupProviderReview";
    }

    public function __invoke($Id_Group, $Action)
    {
        /** @var GroupProviderReviewListerResponse $response */
        $response = $this->queryBus->ask(new GroupProviderReviewListFromGroupQuery(
            $Id_Group,
            $Action
        ));
        return ResponseBuilder::Response($response->response());
    }
}
