<?php

namespace App\Http\Controllers\Owner\GroupProvider;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ParamsValidator;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\GroupProvider\Application\UpdateStatus\UpdateStatusGroupProviderQuery;
use App\Modules\GroupProvider\Infraestructure\GroupProviderValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;

final class GroupProviderUploadMediaController extends Controller
{
    private string $domain = 'GroupProvider';
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->history = new HistoryData(HistoryTables::GROUP_PROVIDER);
    }

    public function __invoke(Request $request, $Id_GroupProvider)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, GroupProviderValidators::UPLOAD_STATUS);

        $this->transaction->begin();
        $this->history->obtainOld($Id_GroupProvider);
        $this->queryBus->ask(new UpdateStatusGroupProviderQuery(
            $Id_GroupProvider,
            $request->input('GroupProvider_MediaStatus'),
        ));
        $this->history->updateBasic($Id_GroupProvider, $request);
        $this->transaction->commit();
        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Proveedor de grupo modificado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
