<?php

namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Group\Application\FillGroupProviderReview\FillGroupProviderReviewQuery;
use App\Modules\Group\Application\UpdateDateUpdate\UpdateGroupDateUpdateQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use Illuminate\Support\Facades\DB;

class GroupProvider extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->oDomain = "Group Provider";
        $this->history = new HistoryData(HistoryTables::GROUP_PROVIDER);
    }

    public static function findGroup($Id_GroupProvider)
    {
        $found = DB::select('call sp_group_provider_index(?)', [$Id_GroupProvider]);
        return count($found) ? $found[0]->Id_Group : null;
    }

    public function insert(Request $Request)
    {
        $oResponse  = array();
        $oValParams = [
            'GroupProvider_Type'    => 'required|int',
            'Id_Group'              => 'required|int',
            'Id_Provider'           => 'required|int',
            'Id_TypeProvider'       => 'required|int'
        ];


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = [
                $Request->input("GroupProvider_Type"),
                $Request->input("Id_Group"),
                $Request->input("Id_Provider"),
                $Request->input('Id_TypeProvider')
            ];
            $oData = DB::select('call sp_group_provider_insert(?,?,?,?)', $oParam);
            $data = null;
            if ($oData[0]->Response_Success == 1) {
                $this->queryBus->ask(new FillGroupProviderReviewQuery($Request->input("Id_Group")));
                $this->history->obtainOld($oData[0]->Response_Id);
                $this->history->insert(
                    $this->history->oldValue,
                    $Request,
                    $Request->input("Id_Group")
                );
                $this->queryBus->ask(new UpdateGroupDateUpdateQuery($Request->input("Id_Group")));
                $data = ['Id' => $oData[0]->Response_Id];
            } else {
            }

            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = $data;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function remark(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(
            'Id_GroupProvider'      => 'required|int',
            'GroupProvider_Remark'  => 'string'
        );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $idGroup = $this->findGroup($Request->input("Id_GroupProvider"));
            $this->history->obtainOld($idGroup);

            $oParam = array(
                $Request->input("Id_GroupProvider"),
                $Request->input("GroupProvider_Remark")
            );
            $oData  = DB::select('call sp_group_provider_remark(?,?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                $this->history->update(
                    $idGroup,
                    $this->history->oldValue,
                    [$Request->all()],
                    $Request
                );
                $this->queryBus->ask(new UpdateGroupDateUpdateQuery($idGroup));
            } else {
            }

            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function delete(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $this->history->obtainOld($Id);
            $Id_Group = self::findGroup($Id);

            $oParam = array($Id);
            $oData  = DB::select('call sp_group_provider_delete(?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                $this->history->delete(
                    $Id_Group,
                    $this->history->oldValue,
                    $Request
                );
                $this->queryBus->ask(new UpdateGroupDateUpdateQuery($Id_Group));
            } else {
            }

            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function index(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array($Id);
            $oData  = DB::select('call sp_group_provider_index(?)', $oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain . " Index";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function list(Request $Request, $Id_Group)
    {
        $oResponse  = array();

        $oResponse = ParamsValidator::Validate_Id($Id_Group, $this->oDomain);


        if ($oResponse["Response_Code"] == 200) {
            $oParam     = array($Id_Group);
            $oData      = DB::select('call sp_group_provider_list(?)', $oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain . " list";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function listFull($Id_Group)
    {
        $oResponse  = array();

        $oResponse = ParamsValidator::Validate_Id($Id_Group, $this->oDomain);


        if ($oResponse["Response_Code"] == 200) {
            $oParam     = [$Id_Group];
            $oData      = DB::select('call sp_group_provider_list_full(?)', $oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain . " list";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
}
