<?php

namespace App\Http\Controllers\Owner\GroupPassengerMedia;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\GroupPassengerMedia\Application\GroupPassengerMediaResponse;
use App\Modules\GroupPassengerMedia\Application\Index\IndexGroupPassengerMediaQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class GroupPassengerMediaIndexController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "GroupPassengerMedia";
    }

    public function __invoke($Id)
    {
        $this->transaction->begin();
        /** @var GroupPassengerMediaResponse $response */
        $response = $this->queryBus->ask(new IndexGroupPassengerMediaQuery($Id));
        $this->transaction->commit();

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [$response],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Index',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
