<?php

namespace App\Http\Controllers\Owner\GroupPassenger;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\GroupPassenger\Application\ListGallery\ListGalleryGroupPassengerQuery;
use App\Modules\GroupPassenger\Infraestructure\GroupPassengerValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Domain\Transaction;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;

final class GroupPassengerListGalleryController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction,
    ) {
        $this->domain = "GroupPassenger";
    }

    public function __invoke(Request $request, $Action)
    {
        (new LaravelValidator())->validate(
            $request->all(),
            $this->domain,
            GroupPassengerValidators::LIST_GALLERY
        );

        /** @var GroupPassengerMediaResponses $response */
        $response = $this->queryBus->ask(new ListGalleryGroupPassengerQuery(
            new DateStart($request->input('DateStart')),
            new DateEnd($request->input('DateEnd')),
            trim($request->input('Search', '')),
            trim($Action),
            $request->input('Page', null),
            $request->input('PageSize', null),
        ));
        $data = array_map([self::class, 'appendCountryPath'], $response->data());

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => $data,
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Listado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }

    public static function appendCountryPath($gpm)
    {
        $gpm->User_Path = config('var.PATH_PUBLIC') . config("var.USER_COUNTRY_THUMB");
        return $gpm;
    }
}
