<?php

namespace App\Http\Controllers\Owner\Flight;

use App\Modules\Flight\Application\Insert\InsertFlightQuery;
use App\Modules\Flight\Infrastructure\FlightValidator;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;

class FlightInsertController
{
    private $domain = 'Flight';
    public function __construct(
        public QueryBus $queryBus
    ) {}

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, FlightValidator::INSERT);
        $this->queryBus->ask(new InsertFlightQuery(
            $request->input('Flight_DateDeparture'),
            $request->input('Flight_DateArrival'),
            $request->input('Flight_Origin'),
            $request->input('Flight_Destination'),
            $request->input('Flight_Number'),
            $request->input('Flight_Carrier'),
            $request->input('Flight_Observation'),
            $request->input('Flight_Type'),
            $request->input('Id_Booking'),
        ));
        $this->queryBus->ask(new InsertGroupQuery());
    }
}
