<?php

namespace App\Http\Controllers\Owner\FactUnit;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\FactUnit\Application\Update\FactUnitUpdaterQuery;
use App\Modules\FactUnit\Application\Update\FactUnitUpdaterResponse;
use App\Modules\FactUnit\Infraestructure\FactUnitValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class FactUnitUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "FactUnit";
        $this->history = new HistoryData(HistoryTables::FACT_UNIT);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, FactUnitValidators::UPDATE);

        $this->history->obtainOld($request->input("Id_FactUnit"));

        /** @var FactUnitUpdaterResponse $response */
        $response = $this->queryBus->ask(new FactUnitUpdaterQuery(
            $request->input('Id_FactUnit'),
            $request->input('FactUnit_Name'),
            $request->input('FactUnit_Abrv'),
            $request->input('FactUnit_Status'),
        ));

        $this->history->updateBasic($request->input("Id_FactUnit"), $request);
        return ResponseBuilder::Response($response->response());
    }
}
