<?php

namespace App\Http\Controllers\Owner\FactReceiptDetail;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\FactProduct\Application\Creator\CreateFactProductQuery;
use App\Modules\FactProduct\Application\Creator\CreateFactProductResponse;
use App\Modules\FactProduct\Domain\FactProductStatus;
use App\Modules\FactReceiptDetail\Application\Create\CreateFactReceiptDetailQuery;
use App\Modules\FactReceiptDetail\Application\Create\CreateFactReceiptDetailResponse;
use App\Modules\FactReceiptDetail\Domain\FactReceiptDetailStatus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\FactReceiptDetail\Infraestructure\FactReceiptDetailValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class FactReceiptDetailInsertController extends Controller
{
    private $domain;
    private HistoryData $history;
    private HistoryData $historyFactProduct;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "FactReceiptDetail";
        $this->history = new HistoryData(HistoryTables::FACT_RECEIPT_DETAIL);
        $this->historyFactProduct = new HistoryData(HistoryTables::FACT_PRODUCT);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, FactReceiptDetailValidators::INSERT);

        $this->history->obtainOld($request->input("Id_FactReceiptDetail"));



        /** @var CreateFactProductResponse $productResponse */
        $productResponse = $this->queryBus->ask(new CreateFactProductQuery(
            0,
            $request->input('FactProduct_Code'),
            $request->input('FactProduct_Name'),
            '',
            FactProductStatus::ACTIVE
        ));

        $this->historyFactProduct->insert([], $request, $productResponse->response()['Response_Data']['Id']);

        /** @var CreateFactReceiptDetailResponse $response */
        $response = $this->queryBus->ask(new CreateFactReceiptDetailQuery(
            $request->input('FactReceiptDetail_Amount'),
            $request->input('FactReceiptDetail_UnitPrice'),
            $request->input('FactReceiptDetail_Discount'),
            $request->input('FactReceiptDetail_Total'),
            FactReceiptDetailStatus::ACTIVE,
            $productResponse->response()['Response_Data']['Id'],
            $request->input('Id_FactTypeOperation'),
            $request->input('Id_FactUnit'),
            $request->input('Id_FactReceipt'),
        ));

        $this->historyFactProduct->insert([], $request, $response->response()['Response_Data']['Id']);

        $this->history->updateBasic($request->input("Id_FactReceiptDetail"), $request);
        return ResponseBuilder::Response($response->response());
    }
}
