<?php

namespace App\Http\Controllers\Owner\FactReceiptDetail;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\FactReceiptDetail\Application\FactReceiptDetailResponse;
use App\Modules\FactReceiptDetail\Application\Index\FactReceiptDetailIndexerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class FactReceiptDetailIndexController extends Controller
{

    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var FactReceiptDetailResponse $response */
        $response = $this->queryBus->ask(new FactReceiptDetailIndexerQuery($Id));

        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse([$response]));
    }
}
