<?php

namespace App\Http\Controllers\Owner\FactPaymentMethod;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\FactPaymentMethod\Application\FactPaymentMethodResponses;
use App\Modules\FactPaymentMethod\Application\List\ListFactPaymentMethodQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class FactPaymentMethodListController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "FactPaymentMethod";
    }

    public function __invoke($Action)
    {
        $this->transaction->begin();
        /** @var FactPaymentMethodResponses $response */
        $response = $this->queryBus->ask(new ListFactPaymentMethodQuery($Action));
        $this->transaction->commit();

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => $response->data(),
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Listado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
