<?php

namespace App\Http\Controllers\Owner\FactCurrency;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\FactCurrency\Application\Update\UpdateFactCurrencyQuery;
use App\Modules\FactCurrency\Infrastructure\FactCurrencyValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class FactCurrencyUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "FactCurrency";
        $this->history = new HistoryData(HistoryTables::HTL_TYPE_ROOM);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, FactCurrencyValidators::UPDATE);
        $this->history->obtainOld($request->input('Id_FactCurrency'));
        $this->transaction->begin();
        $this->queryBus->ask(new UpdateFactCurrencyQuery(
            $request->input('Id_FactCurrency'),
            $request->input('FactCurrency_Name'),
            $request->input('FactCurrency_Abrv'),
            $request->input('FactCurrency_Status'),
        ));
        $this->transaction->commit();
        $this->history->updateBasic($request->input('Id_FactCurrency'), $request);
        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Moneda de Facturación modificada con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
