<?php
namespace App\Http\Controllers\Owner\ExternalReviewProvider;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\ExternalReviewProvider\Application\ExternalReviewProviderIndexer;
use App\Modules\ExternalReviewProvider\Domain\IdExternalReviewProvider;
use App\Modules\ExternalReviewProvider\Infraestructure\MysqlExternalReviewProviderRepository;

class ExternalReviewProviderIndexController extends Controller
{
    public function __construct()
    {
    }

    public function __invoke($Id)
    {
        $response = (new ExternalReviewProviderIndexer(new MysqlExternalReviewProviderRepository()))
            ->__invoke(new IdExternalReviewProvider($Id));

        return ResponseBuilder::Response($response);
    }
}
