<?php
namespace App\Http\Controllers\Owner\CashMovementFactReceipt;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\CashMovementFactReceipt\Application\CashMovementFactReceiptResponse;
use App\Modules\CashMovementFactReceipt\Application\Index\IndexCashMovementFactReceiptQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class CashMovementFactReceiptIndexController extends Controller
{

    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var CashMovementFactReceiptResponse $response */
        $response = $this->queryBus->ask(new IndexCashMovementFactReceiptQuery($Id));

        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse([$response]));
    }
}
