<?php
namespace App\Http\Controllers\Owner\CashMovement;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\CashMovement\Application\Delete\DeleteCashMovementQuery;
use App\Modules\CashMovement\Application\Delete\DeleteCashMovementResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class CashMovementDeleteController extends Controller
{
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    )
    {
        $this->history = new HistoryData(HistoryTables::CASH_MOVEMENT);
    }

    public function __invoke(Request $Request, int $Id)
    {
        $this->history->obtainOld($Id);

        /** @var DeleteCashMovementResponse $response */
        $response = $this->queryBus->ask(new DeleteCashMovementQuery($Id));

        // $response = (new CashMovementDeleter(new MysqlCashMovementRepository()))
        //     ->__invoke(new IdCashMovement($Id));

        $this->history->deleteBasic($Id, $Request);

        return ResponseBuilder::Response($response->response());
    }
}
