<?php

namespace App\Http\Controllers\Owner\BookingUpgradePassenger;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\BookingUpgradePassenger\Application\Reset\ResetBookingUpgradePassengerQuery;
use App\Modules\BookingUpgradePassenger\Application\Reset\ResetBookingUpgradePassengerResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use Illuminate\Support\Facades\DB;

class BookingUpgradePassengerResetController extends Controller
{
    private $domain;
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "Booking Upgrade Passenger";
        $this->history = new HistoryData(HistoryTables::BOOKING_UPGRADE_PASSENGER);
    }

    public static function findBooking($Id_BookingUpgradePassenger)
    {
        $found = DB::select('SELECT `fn_booking_tour_detail_passenger_find_booking`(?,?) as Id_Booking', [$Id_BookingUpgradePassenger, 1]);
        return count($found) ? $found[0]->Id_Booking : null;
    }

    public function __invoke(Request $Request, $Id)
    {
        $this->history->obtainOld($Id);
        /** @var ResetBookingUpgradePassengerResponse $response */
        $response = $this->queryBus->ask(new ResetBookingUpgradePassengerQuery($Id));
        $this->history->update($this->findBooking($Id), $this->history->oldValue, [], $Request);
        return ResponseBuilder::Response($response->response());
    }
}
