<?php

namespace App\Http\Controllers\Owner\BookingTour;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\BookingTourItem\Application\List\BookingTourItemListerQuery;
use App\Modules\BookingTourItem\Application\List\BookingTourItemListerResponse;
use App\Modules\BookingTourItem\Domain\ItemType;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class UpgradeListController
{
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($idBookingTour, $action)
    {
        /** @var BookingTourItemListerResponse */
        $response = $this->queryBus->ask(new BookingTourItemListerQuery(ItemType::UPGRADE, $idBookingTour, $action));

        return ResponseBuilder::Response($response->response());
    }
}