<?php

namespace App\Http\Controllers\Owner\BookingPackage;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\BookingTour\Application\UpdateGroup\UpdateGroupBookingTourQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use Illuminate\Http\Request;

class BookingPackageUpdateController
{
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke(Request $request)
    {
        /** @var BookingTourItemListerResponse */
        $response = $this->queryBus->ask(new UpdateGroupBookingTourQuery(
            $request->input('Id_Booking'),
            $request->input('BookingTour_Group'),
            $request->input('BookingTour_FeeType'),
            $request->input('BookingTour_Full')
        ));

        return ResponseBuilder::Response($response->response());
    }
}
